program Main;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  VrcholThread in 'VrcholThread.pas',
  Defs in 'Defs.pas';

var
  Strom:PTStrom;
  Threads:array [0..255] of TVrcholThr;
  Stopped:boolean;
  l:Integer;
  vrch_cnt:Integer;

//vytvorime pozadovany strom o 3 linearnich vrcholech
procedure Init();
begin
 //zatim je to strom se 2 propojenymi vrcholy
 New(Strom);
 with (Strom^) do
  begin
   Vrcholy.Count := 3;
   New(Vrcholy.Data[0]);
   New(Vrcholy.Data[1]);
   New(Vrcholy.Data[2]);

   Vrcholy.Data[0]^.Childs.Count := 1;
   Vrcholy.Data[1]^.Childs.Count := 2;
   Vrcholy.Data[2]^.Childs.Count := 1;

   Vrcholy.Data[0]^.Childs.Data[0] := Vrcholy.Data[1];
   Vrcholy.Data[1]^.Childs.Data[0] := Vrcholy.Data[0];
   Vrcholy.Data[1]^.Childs.Data[1] := Vrcholy.Data[2];
   Vrcholy.Data[2]^.Childs.Data[0] := Vrcholy.Data[1];
  end;//with
end;//procedure

//vytvorime vlakna
procedure CreateThreads();
var i:Integer;
begin
 //vytvoreni vlaken
 for i := 0 to Strom.Vrcholy.Count-1 do Threads[i] := TVrcholThr.Create(Strom.Vrcholy.Data[i]);

 //zapnuti vlaken
 for i := 0 to Strom.Vrcholy.Count-1 do Threads[i].Resume();
end;//procedure


procedure DestroyThreads();
var i:Integer;
begin
  for i:= 0 to Strom.Vrcholy.Count-1 do FreeAndNil(Threads[i]);
end;//procedure

function PrintVrchol(Vrchol:PTVrchol):string;
var i:Integer;
begin
 for i := 0 to Strom.Vrcholy.Count-1 do
  begin
   if (Strom.Vrcholy.Data[i] = Vrchol) then
    begin
     result := IntToStr(i);
     Exit;
    end;
  end;//for i

 Result := 'Chyba vypisovani: vrchol nenalezen';
end;//procedure

procedure PrintTables();
var i,j,k:Integer;
begin
 for i := 0 to Strom.Vrcholy.Count-1 do
  begin
   writeln('Vrchol ',PrintVrchol(Strom.Vrcholy.Data[i]),':');
   for j := 0 to Strom.Vrcholy.Data[i].Childs.Count-1 do
    begin
     writeln(' - dite : ',PrintVrchol(Strom.Vrcholy.Data[i].Childs.Data[j]));
     for k := 0 to Strom.Vrcholy.Data[i].RoutingChilds.Data[j].NextChilds.Count-1 do
      begin
       writeln('   - routing : ',PrintVrchol(Strom.Vrcholy.Data[i].RoutingChilds.Data[j].NextChilds.Data[k]));
      end;//for k
    end;//for j
   writeln(' - OTHER : ',PrintVrchol(Strom.Vrcholy.Data[i].SentRT));
  end;//for i
end;//procedure

//za ucelem vytvoreni opravdu velkeho stromu prida na nahodne misto 1 vrchol
procedure AddVrchol();
var vrchol:Integer; //na tento vrchol navazat
begin
 vrchol := Random(Strom.Vrcholy.Count-1);

 //pridame vrchol
 New(Strom.Vrcholy.Data[Strom.Vrcholy.Count]);
 Strom.Vrcholy.Count := Strom.Vrcholy.Count + 1;

 //provedeme navaznosti
 Strom.Vrcholy.Data[vrchol]^.Childs.Data[Strom.Vrcholy.Data[vrchol].Childs.Count] := Strom.Vrcholy.Data[Strom.Vrcholy.Count-1];
 Strom.Vrcholy.Data[vrchol]^.Childs.Count := Strom.Vrcholy.Data[vrchol].Childs.Count + 1;

 Strom.Vrcholy.Data[Strom.Vrcholy.Count-1]^.Childs.Count := 1;
 Strom.Vrcholy.Data[Strom.Vrcholy.Count-1]^.Childs.Data[0] := Strom.Vrcholy.Data[vrchol];
end;//procedure

begin
  try
    Randomize();

    writeln('Vytvarim strom o 3 vrcholech...');
    Init();

    writeln('Zadejte pocet pridavnych vrcholu...');
    readln(vrch_cnt);
    for l := 0 to vrch_cnt-1 do AddVrchol();
    writeln('Celkem vrcholu: ',Strom.Vrcholy.Count);

    writeln('Vytvarim thready...');
    CreateThreads();

    Stopped := false;
    while (not Stopped) do
     begin
      Stopped := true;
      for l := 0 to Strom.Vrcholy.Count-1 do
       begin
        if (not Threads[l].Suspended) then
         begin
          Stopped := false;
          Break;
         end;
       end;//for l
     end;//while

    DestroyThreads;

    writeln('Routovani dokonceno');

    PrintTables();

    readln;
  except
    on E:Exception do
      Writeln(E.Classname, ': ', E.Message);
  end;
end.
